# Contributing

Contributions are **welcome** and will be fully **credited**.

We accept contributions via Pull Requests on [Github](https://github.com/aloha/laravel-twilio).

## Pull Requests

- **[PSR-2 Coding Standard](https://github.com/php-fig/fig-standards/blob/master/accepted/PSR-2-coding-style-guide.md)** - The easiest way to apply the conventions is to run `composer cs`.

- **Add tests!** - Your patch won't be accepted if it doesn't have tests. First write a failing test that describes the bug, then write a fix.

- **Document any change in behaviour** - Make sure the `README.md` and any other relevant documentation are kept up-to-date.

- **Keep it Backwards Compatible** - We try to follow [semver v2.0.0](http://semver.org/). Randomly breaking public APIs is not a good idea.

- **One pull request per feature** - If you want to do more than one thing, send multiple pull requests.

- **Send coherent history** - Make sure each individual commit in your pull request is meaningful.

## Running Tests

``` bash
$ composer test
```

**Happy coding**!